using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace Multiple_Resultset
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
    public class Form1 : System.Windows.Forms.Form
    {
        // Instance object variable Declarations
        private SqlConnection cn; 
        private SqlDataAdapter da;
        private SqlCommand sc; 
        private DataSet ds; 

        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.TextBox txtStateWanted;
        internal System.Windows.Forms.Button btnFind;
        internal System.Windows.Forms.DataGrid DataGrid1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

        public Form1()
        {
            try
            {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();
            
                //
                // TODO: Add any constructor code after InitializeComponent call
                //
                
                // Instantiate the new objects
                // Create a connection object
                cn = new SqlConnection("data source=.;database=biblio;uid=admin;pwd=pw");

                // Create the Select Command
                sc = new SqlCommand("SELECT pubid, pubname, city, state FROM publishers"
                    + " WHERE state = @StateWanted " 
                    + " SELECT pubid, isbn, title, price FROM titles WHERE pubid in " 
                    + " (SELECT pubid FROM publishers WHERE state = @StateWanted)",cn);

                // Add a Parameter to the Select Command
                sc.Parameters.Add("@StateWanted", SqlDbType.VarChar, 2).Value = txtStateWanted.Text;

                // Create a DataAdapter - initializing the Select Command
                da = new SqlDataAdapter(sc);

                // Set the DataAdapter Table Mappings
                da.TableMappings.Add("Table", "Publishers");
                da.TableMappings.Add("Table1", "Titles");

                // Create a DataSet Object
                ds = new DataSet();
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }

        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.Label1 = new System.Windows.Forms.Label();
            this.txtStateWanted = new System.Windows.Forms.TextBox();
            this.btnFind = new System.Windows.Forms.Button();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // Label1
            // 
            this.Label1.AutoSize = true;
            this.Label1.Location = new System.Drawing.Point(48, 336);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(76, 13);
            this.Label1.TabIndex = 7;
            this.Label1.Text = "State wanted: ";
            this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // txtStateWanted
            // 
            this.txtStateWanted.Location = new System.Drawing.Point(136, 336);
            this.txtStateWanted.Name = "txtStateWanted";
            this.txtStateWanted.Size = new System.Drawing.Size(144, 20);
            this.txtStateWanted.TabIndex = 6;
            this.txtStateWanted.Text = "CA";
            // 
            // btnFind
            // 
            this.btnFind.Location = new System.Drawing.Point(320, 328);
            this.btnFind.Name = "btnFind";
            this.btnFind.Size = new System.Drawing.Size(104, 32);
            this.btnFind.TabIndex = 5;
            this.btnFind.Text = "Find";
            this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
            // 
            // DataGrid1
            // 
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Top;
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.Size = new System.Drawing.Size(536, 296);
            this.DataGrid1.TabIndex = 4;
            this.DataGrid1.AlternatingBackColor = System.Drawing.Color.OldLace;
            this.DataGrid1.BackColor = System.Drawing.Color.OldLace;
            this.DataGrid1.BackgroundColor = System.Drawing.Color.Tan;
            this.DataGrid1.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.DataGrid1.CaptionBackColor = System.Drawing.Color.SaddleBrown;
            this.DataGrid1.CaptionForeColor = System.Drawing.Color.OldLace;
            this.DataGrid1.FlatMode = true;
            this.DataGrid1.Font = new System.Drawing.Font("Tahoma", 8F);
            this.DataGrid1.ForeColor = System.Drawing.Color.DarkSlateGray;
            this.DataGrid1.GridLineColor = System.Drawing.Color.Tan;
            this.DataGrid1.HeaderBackColor = System.Drawing.Color.Wheat;
            this.DataGrid1.HeaderFont = new System.Drawing.Font("Tahoma", 8F, System.Drawing.FontStyle.Bold);
            this.DataGrid1.HeaderForeColor = System.Drawing.Color.SaddleBrown;
            this.DataGrid1.LinkColor = System.Drawing.Color.DarkSlateBlue;
            this.DataGrid1.ParentRowsBackColor = System.Drawing.Color.OldLace;
            this.DataGrid1.ParentRowsForeColor = System.Drawing.Color.DarkSlateGray;
            this.DataGrid1.SelectionBackColor = System.Drawing.Color.SlateGray;
            this.DataGrid1.SelectionForeColor = System.Drawing.Color.White;
            
            

            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(536, 381);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.Label1,
                                                                          this.txtStateWanted,
                                                                          this.btnFind,
                                                                          this.DataGrid1});
            this.Name = "Form1";
            this.Text = "Form1";
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

        private void AddRelation(DataSet ds)
        {
            try
            {
                // Create new DataColumn objects for parent and child 
                DataColumn parentCol = new DataColumn();
                DataColumn childCol = new DataColumn();

                // Declare a DataRelation object
                DataRelation relPublishers;

                // if we don't already have a relationship defined
                // then define one.
                if (ds.Relations.Count == 0)
                {
                    // Assign the parent and child columns
                    parentCol = ds.Tables["Publishers"].Columns["PubID"];
                    childCol = ds.Tables["Titles"].Columns["PubID"];

                    // Create DataRelation.
                    relPublishers = new DataRelation("PublishersTitles", parentCol, childCol);
                
                    // Add the relation to the DataSet.
                    ds.Relations.Add(relPublishers);
                }
            }
            catch( Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
        }

        private void btnFind_Click(object sender, System.EventArgs e)
        {
            try
            {
                // Clear the DataSet
                ds.Clear();

                // Set the parameter value on the Data Adaptor Select Command
                // with the value from a TextBox control
                da.SelectCommand.Parameters["@StateWanted"].Value = txtStateWanted.Text;

                // Populate the DataSet
                da.Fill(ds);

                // Relate the DataTables in the DataSet
                AddRelation(ds);

                // Populate the DataGrid with the "Publishers" DataTable
                DataGrid1.DataSource = ds.Tables["Publishers"];
            }
            catch(Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
        }
	}
}
